<?php
include('includes/header.php');

// Only admin can manage resellers
if (($_SESSION['role'] ?? 'admin') !== 'admin') {
	header('Location: adduser.php');
	exit;
}

$table_name = 'user';
$page = 'resellers.php';

// Create reseller
if (isset($_POST['create_reseller'])) {
	$username = sanitize($_POST['username'] ?? '');
	$password = sanitize($_POST['password'] ?? '');
    $credits = (int)($_POST['credits'] ?? 0);
	if ($username !== '' && $password !== '') {
		$exists = $db->select($table_name, '*', 'username = :u', '', [':u' => $username]);
		if (empty($exists)) {
			$db->insert($table_name, [
				'username' => $username,
				'password' => $password,
				'role' => 'reseller',
                'credits' => $credits,
				'created_at' => date('Y-m-d H:i:s')
			]);
			echo "<script>window.location.href='$page?status=1'</script>";
			exit;
		}
	}
	echo "<script>window.location.href='$page?status=3'</script>";
	exit;
}

// Update reseller credits (admin only)
if (isset($_POST['update_credits'])) {
    $id = (int)($_POST['id'] ?? 0);
    $credits = (int)($_POST['credits'] ?? 0);
    if ($id > 1) {
        if ($credits < 0) { $credits = 0; }
        $db->update($table_name, ['credits' => $credits], 'id = :id AND role = :r', [':id' => $id, ':r' => 'reseller']);
    }
    echo "<script>window.location.href='$page?status=1'</script>";
    exit;
}

// Add points to reseller (admin only)
// Points are stored in the same DB column: user.credits
if (isset($_POST['add_points'])) {
    $id = (int)($_POST['id'] ?? 0);
    $amount = (int)($_POST['amount'] ?? 0);
    if ($id > 1) {
        if ($amount < 0) { $amount = 0; }
        // Increment points
        $db->query("UPDATE $table_name SET credits = COALESCE(credits,0) + :a WHERE id = :id AND role = :r", [
            ':a' => $amount,
            ':id' => $id,
            ':r' => 'reseller'
        ]);
    }
    echo "<script>window.location.href='$page?status=1'</script>";
    exit;
}

// Update reseller credentials
if (isset($_POST['update_reseller'])) {
	$id = (int)($_POST['id'] ?? 0);
	$username = sanitize($_POST['username'] ?? '');
	$password = sanitize($_POST['password'] ?? '');
	if ($id > 1 && $username !== '' && $password !== '') {
		$db->update($table_name, ['username' => $username, 'password' => $password], 'id = :id AND role = :r', [':id' => $id, ':r' => 'reseller']);
	}
	echo "<script>window.location.href='$page?status=1'</script>";
	exit;
}

// Delete reseller
if (isset($_GET['delete'])) {
	$id = (int)$_GET['delete'];
	if ($id > 1) {
		// delete reseller
		$db->delete($table_name, 'id = :id AND role = :r', [':id' => $id, ':r' => 'reseller']);
		// optionally orphan users are reassigned to admin
		$db->update('menualuser', ['reseller_id' => 1], 'reseller_id = :rid', [':rid' => $id]);
	}
	echo "<script>window.location.href='$page?status=2'</script>";
	exit;
}

$resellers = $db->select($table_name, '*', 'role = :r', 'id DESC', [':r' => 'reseller']);
?>

<div class="col-md-12 mx-auto ctmain-table">
	<div class="card-body">
		<div class="card ctcard">
			<div class="card-header card-header-warning">
				<center>
					<h2><i class="fa fa-users"></i> Resellers</h2>
				</center>
			</div>
			<div class="card-body">
				<div class="row">
					<div class="col-md-6">
						<h4>Create Reseller</h4>
						<form method="post">
							<div class="form-group ctinput">
								<label class="form-label">Username</label>
								<input class="form-control" name="username" type="text" placeholder="Reseller username" required>
							</div>
							<div class="form-group ctinput">
								<label class="form-label">Password</label>
								<input class="form-control" name="password" type="text" placeholder="Reseller password" required>
							</div>
					<div class="form-group ctinput">
						<label class="form-label">Points</label>
						<input class="form-control" name="credits" type="number" min="0" value="0" placeholder="Initial points">
					</div>
							<button class="btn btn-info" name="create_reseller" type="submit"><i class="fa fa-plus"></i> Create</button>
						</form>
					</div>
					<div class="col-md-6">
						<p style="color:#bbb; margin-top:28px;">Each reseller will only see and manage their own customers.</p>
					</div>
				</div>
				<hr>
				<h4>Existing Resellers</h4>
				<div class="table-responsive">
					<table class="table table-striped table-sm">
						<thead style="color:white!important">
						<tr>
							<th>ID</th>
							<th>Username</th>
							<th>Password</th>
							<th>Points (Base)</th>
							<th>Points (Available)</th>
							<th>Actions</th>
						</tr>
						</thead>
						<tbody>
						<?php foreach ($resellers as $r) { ?>
						<?php $avail = resellerAvailableCredits($dbPath, (int)$r['id']); ?>
							<tr>
								<td><?= (int)$r['id'] ?></td>
								<td><?= htmlspecialchars($r['username']) ?></td>
								<td><?= htmlspecialchars($r['password']) ?></td>
								<td>
									<div style="display:flex; flex-wrap:wrap; gap:8px; align-items:center;">
										<form method="post" class="form-inline" style="gap:6px; margin:0;">
											<input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
											<input class="form-control form-control-sm" style="width:110px;" name="credits" type="number" min="0" value="<?= (int)($r['credits'] ?? 0) ?>">
											<button class="btn btn-sm btn-info" name="update_credits" type="submit" title="Set points"><i class="fa fa-save"></i></button>
										</form>

										<form method="post" class="form-inline" style="gap:6px; margin:0;">
											<input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
											<input class="form-control form-control-sm" style="width:90px;" name="amount" type="number" min="0" value="1" placeholder="+">
											<button class="btn btn-sm btn-success" name="add_points" type="submit" title="Add points"><i class="fa fa-plus"></i></button>
										</form>
									</div>
								</td>
								<td>
								<span class="badge badge-info" title="Available = base - accounts - floor(age_days/30)">
									<?= (int)($avail['available'] ?? 0) ?>
								</span>
								<div style="font-size:12px; color:#bbb; margin-top:4px;">
									Accounts: <?= (int)($avail['accounts'] ?? 0) ?> &nbsp;|&nbsp; 30-day: <?= (int)($avail['age_periods'] ?? 0) ?>
								</div>
							</td>
							<td>
									<form method="post" style="display:inline-block; margin-right:8px;">
										<input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
										<input type="hidden" name="username" value="<?= htmlspecialchars($r['username']) ?>">
										<input type="hidden" name="password" value="<?= htmlspecialchars($r['password']) ?>">
										<button class="btn btn-secondary" type="button" onclick="toggleEdit(<?= (int)$r['id'] ?>)"><i class="fa fa-pencil"></i></button>
									</form>
									<a class="btn btn-danger" href="<?= $page ?>?delete=<?= (int)$r['id'] ?>" onclick="return confirm('Delete this reseller? Their customers will be moved to admin.');"><i class="fa fa-trash"></i></a>
							</td>
							</tr>
						<tr id="edit-<?= (int)$r['id'] ?>" style="display:none;">
							<td colspan="6">
									<form method="post" class="row">
										<input type="hidden" name="id" value="<?= (int)$r['id'] ?>">
										<div class="col-md-5">
											<input class="form-control" name="username" value="<?= htmlspecialchars($r['username']) ?>" required>
										</div>
										<div class="col-md-5">
											<input class="form-control" name="password" value="<?= htmlspecialchars($r['password']) ?>" required>
										</div>
										<div class="col-md-2">
											<button class="btn btn-info" name="update_reseller" type="submit"><i class="fa fa-check"></i> Save</button>
										</div>
									</form>
								</td>
							</tr>
						<?php } ?>
						</tbody>
					</table>
				</div>
			</div>
		</div>
	</div>
</div>

<script>
function toggleEdit(id){
	var row = document.getElementById('edit-'+id);
	if (!row) return;
	row.style.display = (row.style.display === 'none') ? '' : 'none';
}
</script>

<?php include('includes/footer.php'); ?>
</body>
</html>
