<?php
// Database path
$dbPath = './.db.db';

// Connect to SQLite database
try {
    $db = new PDO("sqlite:$dbPath");
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Prepare the INSERT statement
    $stmt = $db->prepare("INSERT INTO menualuser (title, username, password, expire_date) VALUES (:title, :username, :password, :expire_date)");

    // Insert 500 random records
    for ($i = 600; $i <= 1500; $i++) {
        $title = 'Title ' . $i;
        $username = 'User' . $i;
        $password = 'Pass' . $i;

        // Generate random year (2025 or 2026)
        $year = mt_rand(2025, 2026);

        // Generate random month and day
        $month = str_pad(mt_rand(1, 12), 2, '0', STR_PAD_LEFT);
        $day = str_pad(mt_rand(1, 28), 2, '0', STR_PAD_LEFT); // Using 28 to avoid invalid dates

        // Format expire_date
        $expire_date = "$year-$month-$day";

        // Bind parameters
        $stmt->bindParam(':title', $title);
        $stmt->bindParam(':username', $username);
        $stmt->bindParam(':password', $password);
        $stmt->bindParam(':expire_date', $expire_date);

        // Execute the query
        $stmt->execute();
    }

    echo "500 records added successfully!";
} catch (PDOException $e) {
    echo "An error occurred: " . $e->getMessage();
}
?>
