<?php 
include ('includes/header.php');

//table name
$table_name = "menualuser";
$page = "adduser.php";



function computeExpireDateFromTerm($term) {
    $dt = new DateTime('now');
    switch ($term) {
        case '30d':
            $dt->modify('+30 days');
            break;
        case '3m':
            $dt->modify('+3 months');
            break;
        case '6m':
            $dt->modify('+6 months');
            break;
        case '12m':
            $dt->modify('+12 months');
            break;
        default:
            // default 30 days
            $dt->modify('+30 days');
            break;
    }
    return $dt->format('Y-m-d');
}

// current user context
$current_role = $_SESSION['role'] ?? 'admin';
$current_uid = (int)($_SESSION['user_id'] ?? 1);

// reseller list for admin assignment
$reseller_list = [];
if ($current_role === 'admin') {
	$reseller_list = $db->select('user', 'id, username', 'role = :r', 'username ASC', [':r' => 'reseller']);
}

// table call (resellers only see their own customers)
if ($current_role === 'reseller') {
	$res = $db->select($table_name, '*', 'reseller_id = :rid', '', [':rid' => $current_uid]);
} else {
	$res = $db->select($table_name, '*', '', '');
}

//update call
if ($current_role === 'reseller') {
	@$resU = $db->select($table_name, '*', 'id = :id AND reseller_id = :rid', '', [':id' => $_GET['update'], ':rid' => $current_uid]);
} else {
	@$resU = $db->select($table_name, '*', 'id = :id', '', [':id' => $_GET['update']]);
}

if(isset($_POST['submitU'])){
	unset($_POST['submitU']);
	$updateData = $_POST;

	// Expire term dropdown (no calendar):
	// If expire_term is provided, set expire_date accordingly. If blank, keep current expire_date.
	if (isset($updateData['expire_term'])) {
		$term = trim($updateData['expire_term']);
		unset($updateData['expire_term']);
		if ($term !== '') {
			$updateData['expire_date'] = computeExpireDateFromTerm($term);
		}
	}

	// resellers can only update their own customers
// resellers can only update their own customers
	if ($current_role === 'reseller') {
		$db->update($table_name, $updateData, 'id = :id AND reseller_id = :rid',[':id' => $_GET['update'], ':rid' => $current_uid]);
	} else {
		$db->update($table_name, $updateData, 'id = :id',[':id' => $_GET['update']]);
	}
	echo "<script>window.location.href='".$page."?status=1'</script>";
}

//submit new
if (isset($_POST['submit'])){
    unset($_POST['submit']);
    $new = $_POST;

    // Expire term dropdown (no calendar)
    $term = trim($new['expire_term'] ?? '30d');
    unset($new['expire_term']);
    $new['expire_date'] = computeExpireDateFromTerm($term);

    // Points rule:
    // Automatically discount reseller credits on customer creation based on expire term:
    // 30d=1, 3m=3, 6m=6, 12m=10.
    if ($current_role === 'reseller') {
        $new['reseller_id'] = $current_uid;
        $new['created_at'] = date('Y-m-d H:i:s');

        $cost = resellerPlanCost($term);
        $info = resellerAvailableCredits($dbPath, $current_uid);
        if ((int)($info['available'] ?? 0) < $cost) {
            echo "<script>window.location.href='".$page."?status=5'</script>";
            exit;
        }

        // Insert customer
        $db->insert($table_name, $new);
        $db->close();

        // Debit reseller credits
        resellerDebitCredits($dbPath, $current_uid, $cost);

        // Refresh session points
        $info2 = resellerAvailableCredits($dbPath, $current_uid);
        $_SESSION['credits'] = (int)($info2['available'] ?? 0);
        echo "<script>window.location.href='".$page."?status=1'</script>";
        exit;
    }

    // Admin flow
    $assignRid = isset($new['reseller_id']) && $new['reseller_id'] !== '' ? (int)$new['reseller_id'] : 1;
    $new['reseller_id'] = $assignRid;
    $new['created_at'] = date('Y-m-d H:i:s');

    // If admin assigns the customer to a reseller, enforce reseller available points.
    if ($assignRid > 1) {
        $cost = resellerPlanCost($term);
        $info = resellerAvailableCredits($dbPath, $assignRid);
        if ((int)($info['available'] ?? 0) < $cost) {
            echo "<script>window.location.href='".$page."?status=5'</script>";
            exit;
        }

        $db->insert($table_name, $new);
        $db->close();

        // Debit reseller credits
        resellerDebitCredits($dbPath, $assignRid, $cost);
        echo "<script>window.location.href='".$page."?status=1'</script>";
        exit;
    }

    // Admin -> admin (no credit usage)
    $db->insert($table_name, $new);
    $db->close();
    echo "<script>window.location.href='".$page."?status=1'</script>";
}

//delete row
if(isset($_GET['delete'])){
	if ($current_role === 'reseller') {
		$db->delete($table_name, 'id = :id AND reseller_id = :rid',[':id' => $_GET['delete'], ':rid' => $current_uid]);
	} else {
		$db->delete($table_name, 'id = :id',[':id' => $_GET['delete']]);
	}
	echo "<script>window.location.href='".$page."?status=2'</script>";
}

?>
<div class="modal fade" id="confirm-delete" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
	<div class="modal-dialog">
		<div class="modal-content" style="background-color: black;">
			<div class="modal-header">
				<h2 style="color: white;">Confirm</h2>
			</div>
			<div class="modal-body" style="color: white;">
				Do you really want to delete?
			</div>
			<div class="modal-footer">
				<button type="button" class="btn btn-primary" data-dismiss="modal">Cancel</button>
				<a style="color: white;" class="btn btn-danger btn-ok">Delete</a>
			</div>
		</div>
	</div>
</div>
<?php
if (isset($_GET['create'])){

//create form
?>

		<div class="col-md-12 mx-auto ctmain-table">
			<div class="card-body">
				<div class="card ctcard">
					<div class="card-header card-header-warning">
						<center>
							<h2><i class="icon icon-bullhorn"></i> Username Input</h2>
						</center>
					</div>			
					<div class="card-body">
						<div class="col-12">
							<h3>Add Username/Password</h3>
						</div>
							<form method="post">
								<div class="form-group ctinput">
									<label class="form-label " for="title">Title</label>
										<input class="form-control" id="description" name="title" placeholder="Title" type="text"/>
								</div>
								<div class="form-group ctinput">
									<label class="form-label " for="username">Username</label>
										<input class="form-control" id="description" name="username" placeholder="Username" type="text"/>
								</div>
                                <div class="form-group ctinput">
									<label class="form-label " for="password">Password</label>
										<input class="form-control" id="description" name="password" placeholder="Password" type="text"/>
								</div>
                                
   <div class="form-group ctinput">
		<label class="form-label " for="expire_term">Expire</label>
		<select class="form-control" id="expire_term" name="expire_term">
			<option value="30d" selected>30 days</option>
			<option value="3m">3 months</option>
			<option value="6m">6 months</option>
			<option value="12m">12 months</option>
		</select>
	</div>
<?php if ($current_role === 'admin') { ?>
							<div class="form-group ctinput">
								<label class="form-label" for="reseller_id">Assign to Reseller</label>
								<select class="form-control" name="reseller_id">
									<option value="1">Admin</option>
									<?php foreach ($reseller_list as $rr) { ?>
									<option value="<?= (int)$rr['id'] ?>"><?= htmlspecialchars($rr['username']) ?></option>
									<?php } ?>
								</select>
							</div>
							<?php } ?>
								<div class="form-group ctinput">
									<center>
										<button class="btn btn-info " name="submit" type="submit">
											<i class="icon icon-check"></i> Submit
										</button>
									</center>
								</div>
							</form>
					</div>
				</div>
			</div>
		</div>
<?php 
}else if (isset($_GET['update'])){ 

//update form
?>
		<div class="col-md-12 mx-auto ctmain-table">
			<div class="card-body">
				<div class="card ctcard">
					<div class="card-header card-header-warning">
						<center>
							<h2><i class="icon icon-bullhorn"></i> DNS & Username Input</h2>
						</center>
					</div>
					
					<div class="card-body">
						<div class="col-12">
							<h3>Edit DNS or Username/Password</h3>
						</div>
							<form method="post">
								<input type="hidden" name="id" value="<?=$_GET['update'] ?>">
								<div class="form-group ctinput">
									<label class="form-label " for="title">Title</label>
										<input class="form-control" id="description" name="title" placeholder="Title" value="<?=$resU[0]['title'] ?>" type="text"/>
								</div>
								<div class="form-group ctinput">
									<label class="form-label " for="username">Username</label>
										<input class="form-control" id="description" name="username" placeholder="Username" value="<?=$resU[0]['username'] ?>" type="text"/>
								</div>
                                <div class="form-group ctinput">
									<label class="form-label " for="password">Password</label>
										<input class="form-control" id="description" name="password" placeholder="Password" value="<?=$resU[0]['password'] ?>" type="text"/>
								</div>
                                
   <div class="form-group ctinput">
		<label class="form-label " for="expire_term">Expire</label>
		<div style="margin-bottom:6px; font-size:12px; opacity:0.8;">
			Current: <?=($resU[0]['expire_date'] ?? '')?>
		</div>
		<select class="form-control" id="expire_term" name="expire_term">
			<option value="">Keep current</option>
			<option value="30d">30 days</option>
			<option value="3m">3 months</option>
			<option value="6m">6 months</option>
			<option value="12m">12 months</option>
		</select>
	</div>
<?php if ($current_role === 'admin') { ?>
							<div class="form-group ctinput">
								<label class="form-label" for="reseller_id">Assign to Reseller</label>
								<select class="form-control" name="reseller_id">
									<option value="1" <?php if ((int)($resU[0]['reseller_id'] ?? 1) === 1) echo 'selected'; ?>>Admin</option>
									<?php foreach ($reseller_list as $rr) { $sel = ((int)($resU[0]['reseller_id'] ?? 1) === (int)$rr['id']) ? 'selected' : ''; ?>
									<option value="<?= (int)$rr['id'] ?>" <?= $sel ?>><?= htmlspecialchars($rr['username']) ?></option>
									<?php } ?>
								</select>
							</div>
							<?php } ?>
								<div class="form-group ctinput">
									<center>
										<button class="btn btn-info " name="submitU" type="submit">
											<i class="icon icon-check"></i> Submit
										</button>
									</center>
								</div>
							</form>
					</div>
				</div>
			</div>
		</div>
<?php
}else if (isset($_GET['update'])){
//update form
?>
		<div class="col-md-8 mx-auto">
			<div class="card-body">
				<div class="card bg-primary text-white">
					<div class="card-header card-header-warning">
						<center>
							<h2><i class="icon icon-bullhorn"></i> DNS & Username Input</h2>
						</center>
					</div>
					
					<div class="card-body">
						<div class="col-12">
							<h3>Edit DNS or Username/Password</h3>
						</div>
							<form method="post">
								<input type="hidden" name="id" value="<?=$_GET['update'] ?>">
								<div class="form-group">
									<label class="form-label " for="title">Title</label>
										<input class="form-control" id="description" name="title" placeholder="Title" value="<?=$resU[0]['title'] ?>" type="text"/>
								</div>
								<div class="form-group">
									<label class="form-label " for="dns">DNS</label>
										<input class="form-control" id="description" name="url" placeholder="DNS" value="<?=$resU[0]['url'] ?>" type="text"/>
								</div>
								<div class="form-group">
									<center>
										<button class="btn btn-info " name="submitU" type="submit">
											<i class="icon icon-check"></i> Submit
										</button>
									</center>
								</div>
							</form>
					</div>
				</div>
			</div>
		</div>
<?php
 }else{
//main table/form
	 ?>

		<div class="col-md-8 mx-auto">
			<div class="card-body">
				<div class="card bg-primary text-white">
					<div class="card-header card-header-warning">
						<center>
							<h2><i class="icon icon-commenting"></i> Current DNSs & Users</h2>
						</center>
					</div>
					<div class="card-body" >
						<div class="col-12">
							<center>
								<a id="button" href="./<?=$page ?>?create" class="btn btn-info">New DNS/User</a>
							</center>
						</div>
						<br>
						<div class="table-responsive">
							<table class="table table-striped table-sm">
							<thead style="color:white!important">
								<tr>
									<th>Title</th>
									<th>DNS</th>
									<th>Edit&nbsp&nbsp&nbspDelete</th>
								</tr>
							</thead>
							<?php foreach ($res as $row) {
							?>
							<tbody>
								<tr>
									<td><?=$row['title'] ?></a></td>
									<td><?=$row['url'] ?></td>
									<td>
									<a class="btn btn-info btn-ok" href="<?=$page ?>?update=<?=$row['id'] ?>"><i class="fa fa-pencil-square-o"></i></a>
									&nbsp&nbsp&nbsp
									<a class="btn btn-danger btn-ok" href="#" data-href="<?=$page ?>?delete=<?=$row['id'] ?>" data-toggle="modal" data-target="#confirm-delete"><i class="fa fa-trash-o"></i></a>
									</td>
								</tr>
							</tbody>
							<?php
							}?>
							</table>
						</div>
						</div>
					</div>
				</div>


	</div>
<?php }?>

<?php include ('includes/footer.php');?>

</body>
</html>